--------------------------------------------------------------------
--            SymCACP Script Module 1       
-- Symmetrical CA Control Panel   symCACPscript-1
--file for strip analysis
-- modified for script2
-- Run length version. Smaller data set by recording only the the number of each runleng for each pattern
--------------------------------------------------------------------
--  P. Rendell   11/08/2020
--------------------------------------------------------------------
-- O/P
-- RULE,GEO, WD, SEED,  STRIPDIR, RUNLENG, CNT

--==============================================================================
------------------------------------------------------------

local scriptType = "script-strip2RL"
local m={}			-- class table
local comProcs			-- common Procedures
local logFile
local g = golly()
local scriptFileData
local logDiverted = false
local gr = require("buildUni") 
--  "r" = rule, "s" = seed, "d" = decimal "t" = text, "g" = geo
-- "R" = required
m.colonList = {['WIDTH'] = {"d","R"},['RULES'] = {"r","R"}, ['SEEDS'] = {"s","R"}}
m.equalList = {['LOGFILE'] = {'t',""}, ['RESULTS_OLD'] = {'t',""}, ['RESULTS_NEW'] = {'t',"R"},
                   ['STEP1'] = {"d","R"}, ['STRIPLENG'] = {"d","R"},  ['CELL_X'] = {'d',"R"}, ['CELL_Y'] = {'d',"R"},
                   ['GEO'] = {'g',""} }
------------------------------------------------------------------------------------------------


--==============================================================================
------------------------------------------------------------------------------------------------

function m.init(lf, cp)
   scriptFileData = {}
   comProcs = cp
   logFile = lf
end

------------------------------------------------------------------------------------------------
function m.buildParmVal(cmd, value, segNo)
   if (scriptFileData[cmd]) then
      m.report.collect("Previous value overwriten "..cmd.." = "..value.."\n",true, segNo)
   end
   scriptFileData[cmd] = value
end

------------------------------------------------------------------------------------------------
function m.buildParmLst(cmd, parms, segNo)
   if (not scriptFileData[cmd]) then
      scriptFileData[cmd] = {}
   end
   for i, parm in pairs(parms) do
      table.insert(scriptFileData[cmd],parm)
   end
end

------------------------------------------------------------------------------------------------
function m.validateScript()
   if not scriptFileData.HIGHT then
      scriptFileData.HIGHT = scriptFileData.WIDTH
   end
   if not scriptFileData.GEO then
      scriptFileData.GEO = "D"
   end
   return true
end
--==============================================================================
--==============================================================================

local function addRunLen(rltab,runLen)
   if (rltab[runLen]) == nil then
      rltab[runLen] = 1
   else
      rltab[runLen] = rltab[runLen] + 1
   end
   return(rltab)
end

--==============================================================================

local function stripVD(outData,h, dir)
   -- leng is whole universe loop. join ends so that all samples are between state changes
   -- dir 'V', 'D'
   local x = h.x
   local y = h.y
   local dist = 0
   local runLen = {}
   local xyMax = (h.width-1)//2
   g.show("h.width "..(h.width-1)//2)
   g.show("xymax "..xyMax)
   local strip = 1
   local lastState = g.getcell(x,y)
   local started = false
   local doneLen = 0
   local state, xInc, yInc
   if (dir == 'V') then
      xInc = 0
   else
     xInc = 1
   end
   function modXY(v)
      if v > xyMax then
         v = v - h.width
      end
      return v
   end
   while doneLen < h.width do
      y = modXY(y + 1)
      x = modXY(x + xInc)
      dist = modXY(dist+1)
      state = g.getcell(x,y)
      if (state == lastState) then
         strip = strip +1
      else   
         runLen = addRunLen(runLen,strip)
         strip = 1
      end
      lastState = state
      doneLen = doneLen + 1
   end
   if (strip > 1) then
      runLen = addRunLen(runLen,strip - 1)
   end
   for  rlInd,rlVal in pairs(runLen) do
      outData[#outData+1] = string.format("%s,%s,%s,%s,%s,%s,%s\n", h.rule, h.geo, h.width, h.seed, dir, rlInd, rlVal)
   end
end
------------------------------------------------------------
------------------------------------------------------------
-- If a run is interruppted then the last seed run can be ignored as it will be incomplete.
-- 
local function openOutFile()
   local s = {}
   local lastSeedRun = {}
   local lastSeedRunKey = ''
   local inFile, outFile, line, words, key, keyFound, noLines
   local outFileOpen = false
   s.linesDone = {}
   if scriptFileData then
      inFile = io.open ( scriptFileData.RESULTS_NEW , "r")
      if inFile and scriptFileData.RESULTS_OLD then         
         outFile = io.open ( scriptFileData.RESULTS_OLD , "w")
         if outFile then
            line = inFile:read("*l")
            while line do
               if not line:upper():find("RULE") then
                  outFile:write(line..'\n')
               end
               line = inFile:read("*l")
            end
            inFile:close()
            outFile:close()
            s.outFile = io.open ( scriptFileData.RESULTS_NEW , "w")
            s.outFile:write("RULE,GEO,WIDTH,SEED,STRIPDIR,RUNLENG,CNT\n")
            outFileOpen = true
            inFile = io.open ( scriptFileData.RESULTS_OLD , "r")
            if s.outFile and inFile then
               line = inFile:read("*l")
               keyFound = false
               while line do
                  if not line:upper():find("RULE") then
                     words = split(line)
                     if (#words == 7) then		-- 1 RULE, 2 GEO, 3 WIDTH, 4 SEED, 5 STRIPDIR, 6 RUNLENG, 7 CNT
                        key = words[1]..':'..words[2]..':'..words[3]..':'..words[4]..':'..words[5]
                      --keyV = h.rule..':'..h.geo..':'..h.width..':'..h.seed..':V'

                        if (key ~= lastSeedRunKey) then
                           for i = 1, #lastSeedRun do
                              s.outFile:write(lastSeedRun[i]..'\n')
                           end
                           s.linesDone[lastSeedRunKey] = true
                           lastSeedRun = {}
                           lastSeedRunKey = key
                        end
                        lastSeedRun[#lastSeedRun+1] = line
                     else
                        logFile:write('openOutFile line '..line..' not 7 words\n')
                     end
                  end
                  line = inFile:read("*l")
               end
            else
               logFile:write("openOutFile (2nd) files not open infile:"..comProcs.bool2txt(inFile).." outfile:"..comProcs.bool2txt(m.outFile).."\n")
               s.outFile:close()
               outFileOpen = false
            end
         else
            comProcs.showTextOV('Failed to input output file '..scriptFileData.RESULTS_NEW)
            logFile:write('Failed to open input file '.."scriptFileData.RESULTS_NEW\n")
         end
      end
      if inFile then
         inFile:close()
      end
      if not outFileOpen then
         s.outFile = io.open ( scriptFileData.RESULTS_NEW , "w")
         s.outFile:write("RULE,GEO,WIDTH,SEED,STRIPDIR,RUNLENG,CNT\n")
      end
      if not s.outFile then
         comProcs.showTextOV('Failed to open output file '..scriptFileData.RESULTS_NEW)
         logFile:write('Failed to open input file '.."scriptFileData.RESULTS_NEW\n")
      end
   else
      comProcs.showTextOV('No Script file Loaded')
   end
   return(s)
end
------------------------------------------------------------

local function divertLog()
   res = true
   local log = io.open ( scriptFileData.LOGFILE , "w")
   if log then
      logFile:write('Diverting to logfile '..scriptFileData.LOGFILE..'\n')
      logDiverted = true
      logFile:close()
      logFile = log
      log = nil
      comProcs.newLog(logFile)
   else
      logFile:write('Failed to divert to logfile '..scriptFileData.LOGFILE..'\n')
      res = false
   end
   return res
end
------------------------------------------------------------

local function reDivertLog()
   if logDiverted then
      logFile:close()
      logFile = comProcs.oldLog()
      logFile:write('Continue after log diversion\n')
   end
   logDiverted = false
end
------------------------------------------------------------

function m.run(segmentNo)

   ---------------------  script data-----------------------
   --  WIDTH =,HIGHT =,RANDSEED =, STRIPLENG =, DO=STRIP
   --  SEEDS:, STEP1 =,RULES:
   ---------------------------------------------------------
   local seed, tx,ty, gen, outFile, inFile
   local line, key, keyFound, headerLine, noLines
   local outData = {}
   local stop = false
   local h = {}
   local startTime = os.clock()
   g.show("Script Strip Analysis")

   g.show('Strip Analysis Started')
   logFile:write('\nStrip Analysis Started\n')
   if scriptFileData then
      if scriptFileData.LOGFILE then
         logDiverted = divertLog(scriptFileData.LOGFILE)
      end
      comProcs.LogScript(segmentNo)
      local geoList = {'D','O'}
      if scriptFileData.GEO ~= 'B' then
         geoList = {scriptFileData.GEO}
      end
      s = openOutFile()
      if s.outFile then
         for ir = 1, #scriptFileData.RULES,1 do
            h.rule = scriptFileData.RULES[ir]
            g.new('SymCACP Script '..scriptFileData.RESULTS_NEW..' '..h.rule..' ')
            for is = 1, #scriptFileData.SEEDS,1 do
               h.seed = scriptFileData.SEEDS[is]
               for widthI,widthV in pairs(scriptFileData.WIDTH) do    
                  h.width = widthV
                  h.hight = h.width
                  for geoI,geoV in pairs(geoList) do
                     h.geo = geoV:sub(1,2)
                     h.x = scriptFileData.CELL_X
                     h.y = scriptFileData.CELL_Y
                     h.gen = scriptFileData.STEP1
                     keyV = h.rule..':'..h.geo..':'..h.width..':'..h.seed..':V'
                     keyD = h.rule..':'..h.geo..':'..h.width..':'..h.seed..':D'
                     if (not s.linesDone[keyV]) or (not s.linesDone[keyD]) then
                        gr.doBuild(' SymCACP StripRL ', h.width, h.hight, h.seed, h.geo, h.rule)  -- w, h, seed, rule, format
                        g.run(scriptFileData.STEP1)
                        g.update()
                        gen = g.getgen()
                        outData = {}
                        if (not s.linesDone[keyD]) then stripVD(outData,h,'D') end
                        if (not s.linesDone[keyV]) then stripVD(outData,h,'V') end
                        for i,line in pairs(outData) do
                           s.outFile:write(line) 
                        end
                        s.outFile:flush()
                        event = g.getevent()
                        if (event:find("^key") or event:find("^oclick"))  then
                           logFile:write("doCollectChange stoped by user action Rule "..h.rule.." seed "..h.seed.."\n")
                           stop = true
                           break
                        end
                     else
                        logFile:write("strip old key "..keyV..' and '..keyD..'\n')  
                     end
                     if stop then break end
                  end
               end
               if stop then break end
            end
            if stop then break end
         end
         s.outFile:close()
      else
         comProcs.showTextOV('Failed to open output file '..scriptFileData.RESULTS_NEW)
      end
      local elapsed = os.clock()-startTime
      local elHrs = math.floor(elapsed/3600)
      local elMins = math.floor((elapsed-elHrs*3600)/60)
      local elSecs = (elapsed-elHrs*3600-elMins*60)
      g.show(string.format("Finished Run Length in %2d Hrs %2d Mins %2.2f Secs\n", elHrs,elMins,elSecs  ))
      logFile:write(string.format("Finished Run Length in %2d Hrs %2d Mins %2.2f Secs\n", elHrs,elMins,elSecs  ))
      logFile:flush()
      if logDiverted then
         reDivertLog()
      end
   else
      comProcs.showTextOV('No Script file Loaded')
   end   
end

return m
------------------------------------------------------------
